/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.files;

import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.sort.Sortable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileManager
implements Sortable {
    private static final int CopyBufferSize = 0x100000;
    private File Archivo;
    private long FileLength;
    private String FileName;
    private String FilePath;
    private String Separador;
    private InputStream Entrada = null;
    private OutputStream Salida = null;
    private long FilePosition;
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int ERROR_ISNOFILE = 1;
    public static final int ERROR_FILENOTFOUND = 2;
    public static final int ERROR_IO = 3;
    public static final int ERROR_NOWRITOPEN = 4;
    public static final int ERROR_NOREADOPEN = 5;
    public static final int ERROR_NOCREATEOUTPUTFILE = 6;

    public FileManager(String Archivo) {
        this.Archivo = new File(Archivo);
        if (this.Archivo.exists()) {
            if (this.Archivo.isFile()) {
                this.FileLength = this.Archivo.length();
                this.FileName = this.Archivo.getName();
                this.FilePath = this.Archivo.getParent();
                this.Separador = File.separator;
            } else if (this.Archivo.isDirectory()) {
                this.FileLength = -1L;
                this.FileName = null;
                this.FilePath = this.Archivo.getParent();
                this.Separador = File.separator;
            }
        } else {
            this.FileLength = -1L;
            this.FileName = this.Archivo.getName();
            this.FilePath = this.Archivo.getParent();
            this.Separador = File.separator;
        }
    }

    public String getFileName() {
        String lSalida = null;
        if (this.Archivo.isFile()) {
            lSalida = this.FileName;
        }
        return lSalida;
    }

    public String getFileBaseName() {
        String BaseName = null;
        if (this.Archivo.isFile()) {
            BaseName = this.FileName.lastIndexOf(".") > 0 ? this.FileName.substring(0, this.FileName.lastIndexOf(".")) : new String(this.FileName);
        }
        return BaseName;
    }

    public String getFileExtension() {
        String Extension = null;
        if (this.Archivo.isFile()) {
            Extension = this.FileName.lastIndexOf(".") > 0 ? this.FileName.substring(this.FileName.lastIndexOf("."), this.FileName.length()) : new String("");
        }
        return Extension;
    }

    public String getFilePath() {
        return this.FilePath;
    }

    public long getFileLength() {
        long lSalida = -1L;
        if (this.Archivo.exists()) {
            if (this.Archivo.isFile()) {
                if (this.Archivo.length() != this.FileLength) {
                    this.FileLength = this.Archivo.length();
                }
                lSalida = this.FileLength;
            } else {
                this.FileLength = -1L;
            }
        } else {
            this.FileLength = -1L;
        }
        return lSalida;
    }

    public String getSeparador() {
        return this.Separador;
    }

    public String getAbsoluteFilePath() {
        String AbsoluteFilePath = null;
        if (this.Archivo.isFile()) {
            AbsoluteFilePath = new String(this.FilePath + this.Separador + this.FileName);
        }
        return AbsoluteFilePath;
    }

    public boolean canWrite() {
        return this.Archivo.canWrite();
    }

    public boolean canRead() {
        return this.Archivo.canRead();
    }

    public boolean canExecute() {
        boolean lSalida = false;
        if (this.Archivo.isFile()) {
            lSalida = this.Archivo.canExecute();
        }
        return lSalida;
    }

    public boolean Delete() {
        boolean lSalida = this.Archivo.delete();
        if (this.Archivo.exists()) {
            if (this.Archivo.isFile()) {
                if (this.Archivo.length() != this.FileLength) {
                    this.FileLength = this.Archivo.length();
                }
            } else {
                this.FileLength = -1L;
            }
        } else {
            this.FileLength = -1L;
        }
        return lSalida;
    }

    public boolean Wipe() throws UtilsException {
        boolean rSalida = false;
        if (this.Archivo.isFile() && this.FileLength > 0L) {
            try {
                byte[] byArray;
                this.Salida = new FileOutputStream(this.Archivo);
                if (this.FileLength > 0x100000L) {
                    byte[] Buffer2 = new byte[0x100000];
                } else {
                    byArray = new byte[(int)this.FileLength];
                }
                MersenneTwisterPlus mersenneTwisterPlus = new MersenneTwisterPlus();
                for (long i = 0L; i < this.FileLength; i += (long)byArray.length) {
                    mersenneTwisterPlus.nextBytes(byArray);
                    this.Salida.write(byArray);
                }
            }
            catch (IOException e) {
                throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Creado", 6);
            }
            finally {
                try {
                    this.Salida.close();
                    this.Salida = null;
                    this.Delete();
                    rSalida = true;
                }
                catch (IOException e) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Wiped", 6);
                }
            }
        }
        return rSalida;
    }

    public boolean Exists() {
        boolean lSalida = this.Archivo.exists();
        if (lSalida && this.Archivo.isFile()) {
            if (this.Archivo.length() != this.FileLength) {
                this.FileLength = this.Archivo.length();
            }
        } else {
            this.FileLength = -1L;
        }
        return lSalida;
    }

    public boolean Rename(String NewFileName) {
        File Nuevo = new File(NewFileName);
        return this.Archivo.renameTo(Nuevo);
    }

    public void Open(int mode) throws UtilsException {
        if (!this.Archivo.exists() && mode == 1) {
            try {
                this.Entrada = null;
                this.Salida = new FileOutputStream(this.Archivo);
            }
            catch (FileNotFoundException ex) {
                throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Creado", 6);
            }
        } else if (this.Archivo.isFile()) {
            if (mode == 0) {
                try {
                    this.Entrada = new FileInputStream(this.Archivo);
                    this.Salida = null;
                }
                catch (FileNotFoundException ex) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO encontrado", 2);
                }
            } else if (mode == 1) {
                try {
                    this.Entrada = null;
                    this.Salida = new FileOutputStream(this.Archivo);
                }
                catch (FileNotFoundException ex) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Creado", 6);
                }
            }
        } else {
            throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        }
        this.FilePosition = 0L;
    }

    public void Close() throws UtilsException {
        if (this.Archivo.isFile()) {
            if (this.Entrada != null) {
                try {
                    this.Entrada.close();
                }
                catch (IOException ex) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
                }
            }
            if (this.Salida != null) {
                try {
                    this.Salida.close();
                }
                catch (IOException ex) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
                }
            }
        } else {
            throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        }
        this.FileLength = this.Archivo.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long Write(byte[] b) throws UtilsException {
        long NumBytesWrite = -1L;
        if (!this.Archivo.isFile()) throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        if (this.Salida == null) throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Abierto para escritura", 4);
        try {
            this.Salida.write(b);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
        }
        NumBytesWrite = b.length;
        this.FilePosition += NumBytesWrite;
        return NumBytesWrite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long Write(byte[] b, int off, int len) throws UtilsException {
        long NumBytesWrite = -1L;
        if (!this.Archivo.isFile()) throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        if (this.Salida == null) throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Abierto para escritura", 4);
        if (len <= 0) return NumBytesWrite;
        if (off >= b.length || off < 0) throw new UtilsException("ERROR: en " + FileManager.class.getName() + " offset fuera de rango", 3);
        if (off + len > b.length) {
            len = b.length - off;
        }
        try {
            this.Salida.write(b, off, len);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
        }
        NumBytesWrite = len;
        this.FilePosition += NumBytesWrite;
        return NumBytesWrite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long Read(byte[] b) throws UtilsException {
        long NumBytesRead = -1L;
        if (!this.Archivo.isFile()) throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        if (this.Entrada == null) throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Abierto para Lectura", 5);
        try {
            NumBytesRead = this.Entrada.read(b);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
        }
        if (NumBytesRead <= 0L) return NumBytesRead;
        this.FilePosition += NumBytesRead;
        return NumBytesRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long Read(byte[] b, int off, int len) throws UtilsException {
        long NumBytesRead = -1L;
        if (!this.Archivo.isFile()) throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        if (this.Entrada == null) throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Abierto para Lectura", 5);
        if (len <= 0) return NumBytesRead;
        if (off >= b.length || off < 0) throw new UtilsException("ERROR: en " + FileManager.class.getName() + " offset fuera de rango", 3);
        if (off + len > b.length) {
            len = b.length - off;
        }
        try {
            NumBytesRead = this.Entrada.read(b, off, len);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
        }
        if (NumBytesRead <= 0L) return NumBytesRead;
        this.FilePosition += NumBytesRead;
        return NumBytesRead;
    }

    public boolean Copy(FileManager FM) throws UtilsException {
        boolean lSalida = false;
        if (FM.isFile()) {
            byte[] Buffer2 = new byte[0x100000];
            FM.Open(0);
            if (this.isDirectory()) {
                FileManager Copia = new FileManager(this.getFilePath() + this.getSeparador() + FM.getFileName());
                if (Copia.Exists()) {
                    Copia.Delete();
                }
                Copia.Open(1);
                long BytesCopied = FM.Read(Buffer2);
                while (BytesCopied > 0L) {
                    Copia.Write(Buffer2, 0, (int)BytesCopied);
                    BytesCopied = FM.Read(Buffer2);
                }
                Copia.Close();
                lSalida = true;
            } else {
                this.Delete();
                this.Open(1);
                long BytesCopied = FM.Read(Buffer2);
                while (BytesCopied > 0L) {
                    this.Write(Buffer2, 0, (int)BytesCopied);
                    BytesCopied = FM.Read(Buffer2);
                }
                this.Close();
                lSalida = true;
            }
            FM.Close();
        }
        return lSalida;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long Skip(long n) throws UtilsException {
        long NumBytesSkiped = -1L;
        if (!this.Archivo.isFile()) throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        if (this.Entrada == null) throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Abierto para Lectura", 5);
        if (n < 0L) throw new UtilsException("ERROR: al Skip " + FileManager.class.getName() + " numero de bytes a ignorar es negativo", 3);
        try {
            NumBytesSkiped = this.Entrada.skip(n);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
        }
        if (NumBytesSkiped <= 0L) return NumBytesSkiped;
        this.FilePosition += NumBytesSkiped;
        return NumBytesSkiped;
    }

    public void Reset() throws UtilsException {
        if (this.Archivo.isFile()) {
            if (this.Entrada != null) {
                try {
                    this.Entrada.close();
                    this.Salida = null;
                    this.Entrada = null;
                }
                catch (IOException ex) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
                }
                try {
                    this.Entrada = new FileInputStream(this.Archivo);
                    this.FilePosition = 0L;
                }
                catch (FileNotFoundException ex) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO encontrado", 2);
                }
            }
            throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Abierto para Lectura", 5);
        }
        throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void Seek(long pos) throws UtilsException {
        if (!this.Archivo.isFile()) throw new UtilsException("ERROR: NO es un ARCHIVO", 1);
        if (this.Entrada == null) throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO Abierto para Lectura", 5);
        if (pos < 0L || pos >= this.FileLength) throw new UtilsException("ERROR: Al Seek " + FileManager.class.getName() + ", Posicion especifidada fuera del rango del tama\u00f1o del archivo " + this.FilePath + this.Separador + this.FileName, 3);
        if (pos < this.FilePosition) {
            try {
                this.Entrada.close();
                this.Salida = null;
                this.Entrada = null;
            }
            catch (IOException ex) {
                throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
            }
            try {
                this.Entrada = new FileInputStream(this.Archivo);
                this.FilePosition = 0L;
                try {
                    long NumBytesSkiped = this.Entrada.skip(pos);
                    if (NumBytesSkiped <= 0L) return;
                    this.FilePosition += NumBytesSkiped;
                    return;
                }
                catch (IOException ex) {
                    throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
                }
            }
            catch (FileNotFoundException ex) {
                throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " NO encontrado", 2);
            }
        }
        if (pos <= this.FilePosition) return;
        long NumBytesSkiped = pos - this.FilePosition;
        try {
            NumBytesSkiped = this.Entrada.skip(NumBytesSkiped);
            if (NumBytesSkiped <= 0L) return;
            this.FilePosition += NumBytesSkiped;
            return;
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: ARCHIVO " + this.FilePath + this.Separador + this.FileName + " IO Error", 3);
        }
    }

    public boolean isReadOpen() {
        boolean lSalida = this.Entrada != null && this.Salida == null;
        return lSalida;
    }

    public boolean isWriteOpen() {
        boolean lSalida = this.Entrada == null && this.Salida != null;
        return lSalida;
    }

    public boolean isFile() {
        boolean lSalida = false;
        if (this.Archivo.exists()) {
            if (this.Archivo.isFile()) {
                if (this.Archivo.length() != this.FileLength) {
                    this.FileLength = this.Archivo.length();
                }
                lSalida = true;
            } else {
                this.FileLength = -1L;
            }
        } else {
            this.FileLength = -1L;
        }
        return lSalida;
    }

    public boolean isDirectory() {
        return this.Archivo.isDirectory();
    }

    /*
     * WARNING - void declaration
     */
    public FileManager[] ListDirectory() throws UtilsException {
        FileManager[] Archivos = null;
        if (this.Archivo.isDirectory()) {
            String[] Lista = this.Archivo.list();
            if (Lista != null) {
                if (Lista.length > 0) {
                    Archivos = new FileManager[Lista.length];
                    int i = 0;
                    while (i < Lista.length) {
                        void var3_3;
                        void var2_2;
                        Archivos[var3_3] = new FileManager(this.FilePath + this.Separador + (String)var2_2[var3_3]);
                        ++var3_3;
                    }
                }
            } else {
                throw new UtilsException("ERROR: Error de IO", 3);
            }
        }
        return Archivos;
    }

    /*
     * WARNING - void declaration
     */
    public FileManager[] ListDirectory(FilenameFilter Filter2) throws UtilsException {
        FileManager[] Archivos = null;
        if (this.Archivo.isDirectory()) {
            String[] Lista = this.Archivo.list(Filter2);
            if (Lista != null) {
                if (Lista.length > 0) {
                    Archivos = new FileManager[Lista.length];
                    int i = 0;
                    while (i < Lista.length) {
                        void var4_4;
                        void var3_3;
                        Archivos[var4_4] = new FileManager(this.FilePath + this.Separador + (String)var3_3[var4_4]);
                        ++var4_4;
                    }
                }
            } else {
                throw new UtilsException("ERROR: Error de IO", 3);
            }
        }
        return Archivos;
    }

    @Override
    public long Metrica() {
        long lSalida = -1L;
        if (this.Archivo.isFile()) {
            lSalida = this.FileLength;
        }
        return lSalida;
    }

    @Override
    public int Order(Sortable Other) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double MetricaDouble() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static String getPathToJarfileDir(Object classToUse) {
        String url = classToUse.getClass().getResource("/" + classToUse.getClass().getName().replaceAll("\\.", "/") + ".class").toString();
        int Pos = url.indexOf(47);
        if (Pos > 0) {
            ++Pos;
        }
        url = url.substring(Pos).replaceFirst("/[^/]+\\.jar!.*$", "/");
        File dir = new File(url);
        url = dir.getAbsolutePath();
        url = url.replaceAll("\\\\", "/");
        url = url.replaceAll("%20", " ");
        return url;
    }
}

