/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.disruptor;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Sequence {
    protected static final long INITIAL_VALUE = -1L;
    private long Value;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock rl = this.rwl.readLock();
    private final Lock wl = this.rwl.writeLock();

    public Sequence() {
        this.wl.lock();
        try {
            this.Value = -1L;
        }
        finally {
            this.wl.unlock();
        }
    }

    public Sequence(long initialValue) {
        this.wl.lock();
        try {
            this.Value = initialValue;
        }
        finally {
            this.wl.unlock();
        }
    }

    public long get() {
        long Salida;
        this.rl.lock();
        try {
            Salida = this.Value;
        }
        finally {
            this.rl.unlock();
        }
        return Salida;
    }

    public void set(long value) {
        this.wl.lock();
        try {
            this.Value = value;
        }
        finally {
            this.wl.unlock();
        }
    }

    public void setVolatile(long value) {
        this.wl.lock();
        try {
            this.Value = value;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(long expectedValue, long newValue) {
        boolean Salida = false;
        this.wl.lock();
        try {
            if (this.Value == expectedValue) {
                this.Value = newValue;
                Salida = true;
            }
        }
        finally {
            this.wl.unlock();
        }
        return Salida;
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long increment) {
        long currentValue;
        long newValue = -1L;
        while (!this.compareAndSet(currentValue = this.get(), newValue = currentValue + increment)) {
        }
        return newValue;
    }

    public String toString() {
        return Long.toString(this.get());
    }
}

