/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.kerneltasks;

import com.valhalanetworks.utils.converters.Base64;
import com.valhalanetworks.utils.kerneltasks.VTask;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KernelTasks
implements Runnable {
    private static final int MAXQUEUESIZE = 65536;
    private static final int MINQUEUESIZE = 128;
    private static final int MAINTHREADSLEEP = 10;
    private static final int DEFMAXIMUMPOOLSIZEKEEPALIVETIME = 30;
    private static final long QUEUEWRITETIMEOUT = 100L;
    private static final long QUEUEREADTIMEOUT = 10L;
    private LoggerManager vLog;
    private MersenneTwisterPlus Random;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private Thread Ejecutor;
    private int NumCPUs;
    private int ThreadCorePoolSize;
    private int MaximumPoolSize;
    private int MaximumPoolSizekeepAliveTime;
    private int FIFOSize;
    @GuardedBy(value="rwl")
    private PriorityBlockingQueue<VTask> FIFO = null;
    @GuardedBy(value="rwl")
    private boolean isFinished;
    @GuardedBy(value="rwl")
    private boolean Ejecutar;
    @GuardedBy(value="rwl")
    private boolean isStarted;
    private ThreadPoolExecutor executorPool;
    private String ControlKey = null;

    public KernelTasks(LoggerManager vLog) {
        this.Random = new MersenneTwisterPlus();
        this.vLog = vLog;
        this.NumCPUs = Runtime.getRuntime().availableProcessors();
        this.MaximumPoolSize = 2 * this.NumCPUs;
        this.ThreadCorePoolSize = this.NumCPUs;
        this.ThreadCorePoolSize = this.ThreadCorePoolSize > 0 ? this.ThreadCorePoolSize : 1;
        this.MaximumPoolSizekeepAliveTime = 30;
        this.FIFOSize = (int)((double)Runtime.getRuntime().freeMemory() * 1.0E-4);
        this.FIFOSize = this.FIFOSize > 65536 ? 65536 : this.FIFOSize;
        this.FIFOSize = this.FIFOSize > 128 ? this.FIFOSize : 128;
        this.FIFO = new PriorityBlockingQueue(this.FIFOSize);
        this.isFinished = true;
        this.Ejecutar = false;
    }

    private void InitThreadPool() {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        RejectedExecutionHandlerImpl rejectionHandler = new RejectedExecutionHandlerImpl();
        this.executorPool = new ThreadPoolExecutor(this.ThreadCorePoolSize, this.MaximumPoolSize, this.MaximumPoolSizekeepAliveTime, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(4 * this.MaximumPoolSize), threadFactory, rejectionHandler);
        this.executorPool.allowCoreThreadTimeOut(true);
    }

    public void Start() {
        boolean LisStarted = false;
        this.isStarted = false;
        this.Ejecutor = new Thread(this);
        this.Ejecutor.setName("Valhala KernelTasks[" + Integer.toHexString(this.Random.nextInt31()) + "]");
        this.Ejecutor.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (KernelTasks.this.vLog != null) {
                    KernelTasks.this.vLog.LogMessage(2, 64, t.getName(), "Uncaught Exception\n" + e.toString());
                } else {
                    Logger.getLogger(t.getName()).log(Level.SEVERE, "Uncaught Exception\n" + e.toString());
                }
                KernelTasks.this.rwl.writeLock().lock();
                try {
                    KernelTasks.this.Ejecutar = false;
                    KernelTasks.this.isFinished = true;
                }
                finally {
                    KernelTasks.this.rwl.writeLock().unlock();
                }
            }
        });
        this.Ejecutor.start();
        do {
            this.rwl.readLock().lock();
            try {
                LisStarted = this.isStarted;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        } while (!LisStarted);
    }

    private String KeyGenerator() {
        String Llave = null;
        MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
        byte[] BinaryKey = new byte[128];
        Random2.nextBytes(BinaryKey);
        try {
            Llave = Base64.encodeBytes(BinaryKey, 4);
        }
        catch (IOException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getName(), e.getMessage());
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
        }
        return Llave;
    }

    public String getControlKey() {
        String Llave = this.KeyGenerator();
        if (this.ControlKey == null) {
            this.ControlKey = new String(Llave);
        }
        return Llave;
    }

    public int waitingTasks() {
        int Size = 0;
        this.rwl.readLock().lock();
        try {
            Size = this.FIFO.size();
            if (this.executorPool != null && this.executorPool.getQueue() != null) {
                Size += this.executorPool.getQueue().size();
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return Size;
    }

    public boolean isFinished() {
        boolean Local = true;
        this.rwl.readLock().lock();
        try {
            Local = this.isFinished;
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return Local;
    }

    public void Shutdown(String CtrlKey) {
        if (this.Ejecutor != null) {
            if (this.vLog != null) {
                this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Shutdown Started");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Shutdown Started");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(1, 16, KernelTasks.class.getName(), "Shutdown Started");
        } else {
            Logger.getLogger(KernelTasks.class.getName()).log(Level.INFO, "Shutdown Started");
        }
        if (this.ControlKey == null || this.ControlKey.equals(CtrlKey)) {
            this.rwl.writeLock().lock();
            try {
                this.Ejecutar = false;
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 32, this.getClass().getName(), "Shutdown Failed due Control Key MISMATCH");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Shutdown Failed due Control Key MISMATCH");
        }
    }

    protected void finalize() throws Throwable {
        this.rwl.writeLock().lock();
        try {
            this.Ejecutar = false;
        }
        finally {
            this.rwl.writeLock().unlock();
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addTask(VTask task) {
        boolean Salida = false;
        if (task != null) {
            this.rwl.writeLock().lock();
            try {
                Salida = this.FIFO.offer(task, 100L, TimeUnit.MILLISECONDS);
            }
            catch (ClassCastException ex) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getName(), ex.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                }
            }
            catch (NullPointerException ex) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getName(), ex.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                }
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
        return Salida;
    }

    public final void clearQueueTask(String CtrlKey) {
        if (this.Ejecutor != null) {
            if (this.vLog != null) {
                this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Tasks Queue Cleaned");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Tasks Queue Cleaned");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(1, 16, KernelTasks.class.getName(), "Tasks Queue Cleaned");
        } else {
            Logger.getLogger(KernelTasks.class.getName()).log(Level.INFO, "Tasks Queue Cleaned");
        }
        if (this.ControlKey == null || this.ControlKey.equals(CtrlKey)) {
            this.rwl.writeLock().lock();
            try {
                this.FIFO.clear();
                this.executorPool.getQueue().clear();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 32, this.getClass().getName(), "Message Queue Clean Failed due Control Key MISMATCH");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Message Queue Clean Failed due Control Key MISMATCH");
        }
        this.rwl.writeLock().lock();
        try {
            this.FIFO.clear();
            this.executorPool.getQueue().clear();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runnable Tarea;
        boolean lEjecutar;
        ThreadPoolExecutor lexecutorPool;
        this.InitThreadPool();
        this.rwl.writeLock().lock();
        try {
            lexecutorPool = this.executorPool;
            this.isFinished = false;
            this.Ejecutar = true;
            lEjecutar = true;
            Tarea = null;
            this.isStarted = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        while (lEjecutar) {
            block53: {
                if (lexecutorPool.getActiveCount() < lexecutorPool.getMaximumPoolSize()) {
                    try {
                        this.rwl.readLock().lock();
                        try {
                            Tarea = this.FIFO.poll(10L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException ex) {
                            if (this.vLog != null) {
                                this.vLog.LogMessage(2, 64, this.getClass().getName(), ex.getLocalizedMessage());
                            } else {
                                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                            }
                        }
                        finally {
                            this.rwl.readLock().unlock();
                        }
                        if (Tarea != null) {
                            lexecutorPool.execute(Tarea);
                        }
                    }
                    catch (NullPointerException ex) {
                        if (this.vLog != null) {
                            this.vLog.LogMessage(2, 64, this.getClass().getName(), ex.getLocalizedMessage());
                            break block53;
                        }
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                    }
                } else {
                    while (lexecutorPool.getActiveCount() > lexecutorPool.getCorePoolSize()) {
                        try {
                            Thread.sleep(this.Random.nextInt(10));
                        }
                        catch (InterruptedException e) {
                            if (this.vLog != null) {
                                this.vLog.LogMessage(2, 64, this.Ejecutor.getName(), e.getMessage());
                                continue;
                            }
                            Logger.getLogger(this.Ejecutor.getName()).log(Level.SEVERE, e.getMessage());
                        }
                    }
                }
            }
            while (lexecutorPool.getQueue().remainingCapacity() == 0) {
                try {
                    Thread.sleep(this.Random.nextInt(10));
                }
                catch (InterruptedException e) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 64, this.Ejecutor.getName(), e.getMessage());
                        continue;
                    }
                    Logger.getLogger(this.Ejecutor.getName()).log(Level.SEVERE, e.getMessage());
                }
            }
            this.rwl.readLock().lock();
            try {
                lEjecutar = this.Ejecutar;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
        lexecutorPool.getQueue().clear();
        lexecutorPool = null;
        try {
            if (this.executorPool != null) {
                this.executorPool.shutdown();
                if (this.executorPool.awaitTermination(this.MaximumPoolSizekeepAliveTime, TimeUnit.SECONDS)) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Thread Pool Finished");
                    } else {
                        Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Thread Pool Finished");
                    }
                } else {
                    this.executorPool.shutdownNow();
                    if (this.executorPool.awaitTermination(this.MaximumPoolSizekeepAliveTime, TimeUnit.SECONDS)) {
                        if (this.vLog != null) {
                            this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Thread Pool Forced to Finished");
                        } else {
                            Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Thread Pool Forced to Finished");
                        }
                    } else if (this.vLog != null) {
                        this.vLog.LogMessage(1, 32, this.Ejecutor.getName(), "Thread Pool NO Finished before TimeOut");
                    } else {
                        Logger.getLogger(this.Ejecutor.getName()).log(Level.WARNING, "Thread Pool NO Finished before TimeOut");
                    }
                }
            } else if (this.vLog != null) {
                this.vLog.LogMessage(2, 32, this.Ejecutor.getName(), "Thread Pool is NULL");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.WARNING, "Thread Pool is NULL");
            }
        }
        catch (InterruptedException ex) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.Ejecutor.getName(), ex.getMessage());
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        catch (SecurityException ex) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.Ejecutor.getName(), ex.getMessage());
            }
            Logger.getLogger(this.Ejecutor.getName()).log(Level.SEVERE, ex.getMessage());
        }
        this.rwl.writeLock().lock();
        try {
            this.isFinished = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private class RejectedExecutionHandlerImpl
    implements RejectedExecutionHandler {
        private RejectedExecutionHandlerImpl() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            int PoolSize = executor.getPoolSize();
            int CorePoolSize = executor.getCorePoolSize();
            int ActiveCount = executor.getActiveCount();
            long CompletedTaskCount = executor.getCompletedTaskCount();
            long TaskCount = executor.getTaskCount();
            boolean Shutdown = executor.isShutdown();
            boolean Terminated = executor.isTerminated();
            if (KernelTasks.this.vLog != null) {
                KernelTasks.this.vLog.LogMessage(2, 64, r.getClass().getName(), "Rejected to be executed by " + r.getClass().getSimpleName());
                KernelTasks.this.vLog.LogMessage(2, 16, r.getClass().getName(), String.format("[%s monitor] [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s", r.getClass().getSimpleName(), PoolSize, CorePoolSize, ActiveCount, CompletedTaskCount, TaskCount, Shutdown, Terminated));
            } else {
                Logger.getLogger(r.getClass().getName()).log(Level.SEVERE, "Rejected to be executed by " + r.getClass().getSimpleName());
                Logger.getLogger(r.getClass().getName()).log(Level.INFO, String.format("[%s monitor] [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s", r.getClass().getSimpleName(), PoolSize, CorePoolSize, ActiveCount, CompletedTaskCount, TaskCount, Shutdown, Terminated));
            }
            try {
                Thread.sleep(KernelTasks.this.Random.nextInt(10));
            }
            catch (InterruptedException e) {
                if (KernelTasks.this.vLog != null) {
                    KernelTasks.this.vLog.LogMessage(2, 64, r.getClass().getSimpleName(), e.getMessage());
                }
                Logger.getLogger(r.getClass().getSimpleName()).log(Level.SEVERE, e.getMessage());
            }
            executor.execute(r);
        }
    }
}

