/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.fec.reedsolomon;

import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.converters.Converter;
import com.valhalanetworks.utils.fec.reedsolomon.GenericGF;
import com.valhalanetworks.utils.fec.reedsolomon.GenericGFPoly;
import java.util.ArrayList;
import java.util.List;

public strictfp final class ReedSolomonEncoder {
    private final GenericGF field;
    private final List<GenericGFPoly> cachedGenerators;

    protected ReedSolomonEncoder(GenericGF GField) {
        if (!GenericGF.QR_CODE_FIELD_256.equals(GField)) {
            throw new IllegalArgumentException("Only QR Code is supported at this time");
        }
        this.field = GField;
        this.cachedGenerators = new ArrayList<GenericGFPoly>();
        this.cachedGenerators.add(new GenericGFPoly(this.field, new int[]{1}));
    }

    protected byte[] RSencode(byte[] Input, int ErrorCorrectionBytes) {
        int i;
        if (ErrorCorrectionBytes == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int dataBytes = Input.length;
        if (dataBytes <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        int[] toEncode = new int[dataBytes + ErrorCorrectionBytes];
        for (i = 0; i < dataBytes; ++i) {
            toEncode[i] = Input[i] & 0xFF;
        }
        GenericGFPoly generator = this.buildGenerator(ErrorCorrectionBytes);
        int[] infoCoefficients = new int[dataBytes];
        System.arraycopy(toEncode, 0, infoCoefficients, 0, dataBytes);
        GenericGFPoly info = new GenericGFPoly(this.field, infoCoefficients);
        info = info.multiplyByMonomial(ErrorCorrectionBytes, 1);
        GenericGFPoly remainder = info.divide(generator)[1];
        int[] coefficients = remainder.getCoefficients();
        int numZeroCoefficients = ErrorCorrectionBytes - coefficients.length;
        for (i = 0; i < numZeroCoefficients; ++i) {
            toEncode[dataBytes + i] = 0;
        }
        ArrayUtils.arrayCopy(coefficients, 0, toEncode, dataBytes + numZeroCoefficients, coefficients.length);
        byte[] Output = Converter.int2byte(toEncode);
        for (i = 0; i < Output.length / 4; ++i) {
            Output[i] = Output[3 + i * 4];
        }
        Output = (byte[])ArrayUtils.resizeArray(Output, Output.length / 4);
        return Output;
    }

    private GenericGFPoly buildGenerator(int degree) {
        if (degree >= this.cachedGenerators.size()) {
            GenericGFPoly lastGenerator = this.cachedGenerators.get(this.cachedGenerators.size() - 1);
            for (int d = this.cachedGenerators.size(); d <= degree; ++d) {
                GenericGFPoly nextGenerator = lastGenerator.multiply(new GenericGFPoly(this.field, new int[]{1, this.field.exp(d - 1)}));
                this.cachedGenerators.add(nextGenerator);
                lastGenerator = nextGenerator;
            }
        }
        return this.cachedGenerators.get(degree);
    }
}

