/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.communications.utils;

import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import com.valhalanetworks.utils.vthreads.annotations.ThreadSafe;

@ThreadSafe
public class SyncroBuffer {
    @GuardedBy(value="this")
    private byte[] buffer = null;

    public synchronized void put(byte in) {
        if (this.buffer != null) {
            int leng = this.buffer.length;
            this.buffer = (byte[])ArrayUtils.resizeArray(this.buffer, leng + 1);
            this.buffer[leng] = in;
        } else {
            this.buffer = new byte[1];
            this.buffer[0] = in;
        }
    }

    public synchronized void put(byte[] in) {
        if (this.buffer != null) {
            int nleng = in.length;
            int oldleng = this.buffer.length;
            this.buffer = (byte[])ArrayUtils.resizeArray(this.buffer, oldleng + nleng);
            ArrayUtils.arrayCopy(in, 0, this.buffer, oldleng, nleng);
        } else {
            int nleng = in.length;
            this.buffer = new byte[nleng];
            ArrayUtils.arrayCopy(in, 0, this.buffer, 0, nleng);
        }
    }

    public synchronized void put(String in) {
        if (this.buffer != null) {
            byte[] StringArray = in.getBytes();
            int nleng = StringArray.length;
            int oldleng = this.buffer.length;
            this.buffer = (byte[])ArrayUtils.resizeArray(this.buffer, oldleng + nleng);
            ArrayUtils.arrayCopy(in, 0, this.buffer, oldleng, nleng);
        } else {
            this.buffer = in.getBytes();
        }
    }

    public synchronized byte[] getall() {
        byte[] OutBuffer = null;
        if (this.buffer != null) {
            OutBuffer = new byte[this.buffer.length];
            ArrayUtils.arrayCopy(this.buffer, 0, OutBuffer, 0, this.buffer.length);
            this.buffer = null;
        }
        return OutBuffer;
    }

    public synchronized byte getByte() {
        byte Valor = 0;
        if (this.buffer != null) {
            Valor = this.buffer[0];
            int OldLeng = this.buffer.length;
            this.buffer = (byte[])(OldLeng > 1 ? (byte[])ArrayUtils.subArray(this.buffer, 1, OldLeng - 1) : null);
        }
        return Valor;
    }

    public synchronized byte[] getBytes(int NumBytes) {
        byte[] OutBuffer = null;
        if (this.buffer != null) {
            int OldLeng = this.buffer.length;
            if (NumBytes > OldLeng) {
                NumBytes = OldLeng;
            }
            if (NumBytes > 0) {
                OutBuffer = (byte[])ArrayUtils.subArray(this.buffer, 0, NumBytes);
                this.buffer = (byte[])(NumBytes == OldLeng ? null : (byte[])ArrayUtils.subArray(this.buffer, NumBytes, OldLeng - NumBytes));
            }
        }
        return OutBuffer;
    }

    public synchronized int length() {
        int Longitud = 0;
        if (this.buffer != null) {
            Longitud = this.buffer.length;
        }
        return Longitud;
    }
}

