/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.bits;

import com.valhalanetworks.utils.exception.UtilsException;

public class BitsUtils {
    public static final int ShiftBiggerSizeBits = 1;
    public static final int ShiftLessThanZero = 2;
    public static final int BitPositionOutsideRange = 4;

    private BitsUtils() {
    }

    public static byte ByteLeftRotation(byte value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 8;
            if (shift <= NumBits) {
                int Tvalue = value;
                return (byte)(((Tvalue &= 0xFF) << shift | Tvalue >>> NumBits - shift) & 0xFF);
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static byte ByteRightRotation(byte value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 8;
            if (shift <= NumBits) {
                int Tvalue = value;
                return (byte)(((Tvalue &= 0xFF) >>> shift | Tvalue << NumBits - shift) & 0xFF);
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static short ShortLeftRotation(short value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 16;
            if (shift <= NumBits) {
                int Tvalue = value;
                return (short)(((Tvalue &= 0xFFFF) << shift | Tvalue >>> NumBits - shift) & 0xFFFF);
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static short ShortRightRotation(short value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 16;
            if (shift <= NumBits) {
                int Tvalue = value;
                return (short)(((Tvalue &= 0xFFFF) >>> shift | Tvalue << NumBits - shift) & 0xFFFF);
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static int IntLeftRotation(int value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 32;
            if (shift <= NumBits) {
                return value << shift | value >>> NumBits - shift;
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static int IntRightRotation(int value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 32;
            if (shift <= NumBits) {
                return value >>> shift | value << NumBits - shift;
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static long LongLeftRotation(long value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 64;
            if (shift <= NumBits) {
                return value << shift | value >>> NumBits - shift;
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static long LongRightRotation(long value, int shift) throws UtilsException {
        if (shift >= 0) {
            int NumBits = 64;
            if (shift <= NumBits) {
                return value >>> shift | value << NumBits - shift;
            }
            throw new UtilsException("ERROR: Bits to rotate is bigger that data bits size", 1);
        }
        throw new UtilsException("ERROR: Bits to rotate is less that Zero", 2);
    }

    public static byte ByteSetBit(byte Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 8) {
            return (byte)((Input | 1 << BitPosition) & 0xFF);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static byte ByteUnsetBit(byte Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 8) {
            return (byte)(Input & ~(1 << BitPosition) & 0xFF);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static short ShortSetBit(short Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 16) {
            return (short)((Input | 1 << BitPosition) & 0xFFFF);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static short ShortUnsetBit(short Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 16) {
            return (short)(Input & ~(1 << BitPosition) & 0xFFFF);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static int IntSetBit(int Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 32) {
            return Input | 1 << BitPosition;
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static int IntUnsetBit(int Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 32) {
            return Input & ~(1 << BitPosition);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static long LongSetBit(long Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 64) {
            return Input | 1L << BitPosition;
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static long LongUnsetBit(long Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 64) {
            return Input & (1L << BitPosition ^ 0xFFFFFFFFFFFFFFFFL);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static int ByteParity(byte Input) {
        int bb = Input & 0xFF;
        int parity = bb ^ bb >> 4;
        parity ^= parity >> 2;
        parity ^= parity >> 1;
        return ~parity & 1;
    }

    public static boolean isByteOddParity(byte Input) {
        int bb = Input & 0xFF;
        int parity = bb ^ bb >> 4;
        parity ^= parity >> 2;
        return ((parity ^= parity >> 1) & 1) != 0;
    }

    public static int ShortParity(short Input) {
        int bb = Input & 0xFFFF;
        int parity = bb ^ bb >> 8;
        parity ^= parity >> 4;
        parity ^= parity >> 2;
        parity ^= parity >> 1;
        return ~parity & 1;
    }

    public static boolean isShortOddParity(short Input) {
        int bb = Input & 0xFFFF;
        int parity = bb ^ bb >> 8;
        parity ^= parity >> 4;
        parity ^= parity >> 2;
        return ((parity ^= parity >> 1) & 1) != 0;
    }

    public static int IntParity(int Input) {
        int bb = Input & 0xFFFFFFFF;
        int parity = bb ^ bb >> 16;
        parity ^= parity >> 8;
        parity ^= parity >> 4;
        parity ^= parity >> 2;
        parity ^= parity >> 1;
        return ~parity & 1;
    }

    public static boolean isIntOddParity(int Input) {
        int bb = Input & 0xFFFFFFFF;
        int parity = bb ^ bb >> 16;
        parity ^= parity >> 8;
        parity ^= parity >> 4;
        parity ^= parity >> 2;
        return ((parity ^= parity >> 1) & 1) != 0;
    }

    public static long LongParity(long Input) {
        long bb = Input & 0xFFFFFFFFFFFFFFFFL;
        long parity = bb ^ bb >> 32;
        parity ^= parity >> 16;
        parity ^= parity >> 8;
        parity ^= parity >> 4;
        parity ^= parity >> 2;
        parity ^= parity >> 1;
        return (parity ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
    }

    public static boolean isLongOddParity(long Input) {
        long bb = Input & 0xFFFFFFFFFFFFFFFFL;
        long parity = bb ^ bb >> 32;
        parity ^= parity >> 16;
        parity ^= parity >> 8;
        parity ^= parity >> 4;
        parity ^= parity >> 2;
        return ((parity ^= parity >> 1) & 1L) != 0L;
    }

    public static long LongPopCount(long Input) {
        long[] S = new long[]{1L, 2L, 4L, 8L, 16L, 32L};
        long[] B = new long[]{0x5555555555555555L, 0x3333333333333333L, 0xF0F0F0F0F0F0F0FL, 0xFF00FF00FF00FFL, 0xFFFF0000FFFFL, 0xFFFFFFFFL};
        long c = Input - (Input >>> 1 & B[0]);
        c = (c >>> (int)S[1] & B[1]) + (c & B[1]);
        c = (c >>> (int)S[2]) + c & B[2];
        c = (c >>> (int)S[3]) + c & B[3];
        c = (c >>> (int)S[4]) + c & B[4];
        return (c >>> (int)S[5]) + c & B[5];
    }

    public static int IntPopCount(int Input) {
        int[] S = new int[]{1, 2, 4, 8, 16};
        int[] B = new int[]{0x55555555, 0x33333333, 0xF0F0F0F, 0xFF00FF, 65535};
        int c = Input - (Input >>> 1 & B[0]);
        c = (c >>> S[1] & B[1]) + (c & B[1]);
        c = (c >>> S[2]) + c & B[2];
        c = (c >>> S[3]) + c & B[3];
        return (c >>> S[4]) + c & B[4];
    }

    public static short ShortPopCount(short Input) {
        short[] S = new short[]{1, 2, 4, 8};
        short[] B = new short[]{21845, 13107, 3855, 255};
        short c = (short)(Input - (Input >>> 1 & B[0]));
        c = (short)((short)(c >>> S[1] & B[1]) + (c & B[1]));
        c = (short)((short)((c >>> S[2]) + c) & B[2]);
        return (short)((short)((c >>> S[3]) + c) & B[3]);
    }

    public static byte BytePopCount(byte Input) {
        byte[] S = new byte[]{1, 2, 4};
        byte[] B = new byte[]{85, 51, 15};
        byte c = (byte)(Input - (Input >>> 1 & B[0]));
        c = (byte)((c >>> S[1] & B[1]) + (c & B[1]));
        return (byte)((c >>> S[2]) + c & B[2]);
    }

    public static byte ByteGetBit(byte Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 8) {
            return (byte)(Input >>> BitPosition & 1);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static byte ShortGetBit(short Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 16) {
            return (byte)(Input >>> BitPosition & 1);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static byte IntGetBit(int Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 32) {
            return (byte)(Input >>> BitPosition & 1);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }

    public static byte LongGetBit(long Input, int BitPosition) throws UtilsException {
        if (BitPosition >= 0 && BitPosition < 64) {
            return (byte)(Input >>> BitPosition & 1L);
        }
        throw new UtilsException("ERROR: Bits Position Outside Range", 4);
    }
}

