/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.converters;

import com.valhalanetworks.utils.exception.UtilsException;

public class Converter {
    private Converter() {
    }

    public static long[] byte2long(byte[] Entrada) throws UtilsException {
        int base = 8;
        int multi = 64 / base;
        long[] Salida = null;
        if (Entrada.length % multi == 0) {
            Salida = new long[Entrada.length / multi];
            for (int i = 0; i < Salida.length; ++i) {
                for (int j = 0; j < multi; ++j) {
                    long temp = Entrada[i * multi + j];
                    temp <<= 64 - base;
                    temp >>>= 64 - base;
                    Salida[i] = Salida[i] | (temp <<= 64 - base - base * j);
                }
            }
        } else {
            throw new UtilsException("ERROR(byte2long): Numero de Bytes no es multiplo de " + multi);
        }
        return Salida;
    }

    public static byte[] long2byte(long[] Entrada) {
        int base = 8;
        int multi = 64 / base;
        byte[] Salida = null;
        Salida = new byte[multi * Entrada.length];
        for (int i = 0; i < Entrada.length; ++i) {
            for (int j = 0; j < multi; ++j) {
                long temp = Entrada[i] << base * j;
                Salida[multi * i + j] = (byte)(temp >>> 64 - base);
            }
        }
        return Salida;
    }

    public static int[] byte2int(byte[] Entrada) throws UtilsException {
        int base = 8;
        int multi = 32 / base;
        int[] Salida = null;
        if (Entrada.length % multi == 0) {
            Salida = new int[Entrada.length / multi];
            for (int i = 0; i < Salida.length; ++i) {
                for (int j = 0; j < multi; ++j) {
                    int temp = Entrada[i * multi + j];
                    temp <<= 32 - base;
                    temp >>>= 32 - base;
                    Salida[i] = Salida[i] | (temp <<= 32 - base - base * j);
                }
            }
        } else {
            throw new UtilsException("ERROR(byte2int): Numero de Bytes no es multiplo de " + multi);
        }
        return Salida;
    }

    public static byte[] int2byte(int[] Entrada) {
        int base = 8;
        int multi = 32 / base;
        byte[] Salida = null;
        Salida = new byte[multi * Entrada.length];
        for (int i = 0; i < Entrada.length; ++i) {
            for (int j = 0; j < multi; ++j) {
                long temp = Entrada[i] << base * j;
                Salida[multi * i + j] = (byte)(temp >>> 32 - base);
            }
        }
        return Salida;
    }

    public static long[] int2long(int[] Entrada) throws UtilsException {
        int base = 32;
        int multi = 64 / base;
        long[] Salida = null;
        if (Entrada.length % multi == 0) {
            Salida = new long[Entrada.length / multi];
            for (int i = 0; i < Salida.length; ++i) {
                for (int j = 0; j < multi; ++j) {
                    long temp = Entrada[i * multi + j];
                    temp <<= 64 - base;
                    temp >>>= 64 - base;
                    Salida[i] = Salida[i] | (temp <<= 64 - base - base * j);
                }
            }
        } else {
            throw new UtilsException("ERROR(int2long): Numero de Bytes no es multiplo de " + multi);
        }
        return Salida;
    }

    public static int[] long2int(long[] Entrada) {
        int base = 32;
        int multi = 64 / base;
        int[] Salida = null;
        Salida = new int[multi * Entrada.length];
        for (int i = 0; i < Entrada.length; ++i) {
            for (int j = 0; j < multi; ++j) {
                long temp = Entrada[i] << base * j;
                Salida[multi * i + j] = (int)(temp >>> 64 - base);
            }
        }
        return Salida;
    }

    public static long[] short2long(short[] Entrada) throws UtilsException {
        int base = 16;
        int multi = 64 / base;
        long[] Salida = null;
        if (Entrada.length % multi == 0) {
            Salida = new long[Entrada.length / multi];
            for (int i = 0; i < Salida.length; ++i) {
                for (int j = 0; j < multi; ++j) {
                    long temp = Entrada[i * multi + j];
                    temp <<= 64 - base;
                    temp >>>= 64 - base;
                    Salida[i] = Salida[i] | (temp <<= 64 - base - base * j);
                }
            }
        } else {
            throw new UtilsException("ERROR(int2long): Numero de Bytes no es multiplo de " + multi);
        }
        return Salida;
    }

    public static short[] long2short(long[] Entrada) {
        int base = 16;
        int multi = 64 / base;
        short[] Salida = null;
        Salida = new short[multi * Entrada.length];
        for (int i = 0; i < Entrada.length; ++i) {
            for (int j = 0; j < multi; ++j) {
                long temp = Entrada[i] << base * j;
                Salida[multi * i + j] = (short)(temp >>> 64 - base);
            }
        }
        return Salida;
    }

    public static String byte2StringHex(byte[] raw) {
        String HEXES = "0123456789ABCDEF";
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static byte[] StringHex2bytes(String hex) {
        int len = hex.length();
        byte[] buf = new byte[(len + 1) / 2];
        int i = 0;
        int j = 0;
        if (len % 2 == 1) {
            buf[j++] = (byte)Converter.hexDigit(hex.charAt(i++));
        }
        while (i < len) {
            buf[j++] = (byte)(Converter.hexDigit(hex.charAt(i++)) << 4 | Converter.hexDigit(hex.charAt(i++)));
        }
        return buf;
    }

    public static boolean isHex(String hex) {
        int len = hex.length();
        int i = 0;
        while (i < len) {
            char ch;
            if ((ch = hex.charAt(i++)) >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') continue;
            return false;
        }
        return true;
    }

    private static int hexDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        return 0;
    }
}

