/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.sort;

import com.valhalanetworks.utils.sort.Sortable;

public class Sorter {
    public static final boolean ASCENDING = true;
    public static final boolean DESCENDING = false;

    private Sorter() {
    }

    private static void AbsoluteAscendQuickSort(Sortable[] Lista, int IndexLo, int IndexHi) {
        int InLo = IndexLo;
        int InHi = IndexHi;
        if (IndexHi > IndexLo) {
            long ValorMedio = Lista[(IndexHi + IndexLo) / 2].Metrica();
            while (InLo <= InHi) {
                while (InLo < IndexHi && Lista[InLo].Metrica() < ValorMedio) {
                    ++InLo;
                }
                while (InHi > IndexLo && Lista[InHi].Metrica() > ValorMedio) {
                    --InHi;
                }
                if (InLo > InHi) continue;
                Sorter.Swap(Lista, InLo, InHi);
                ++InLo;
                --InHi;
            }
            if (IndexLo < InHi) {
                Sorter.AbsoluteAscendQuickSort(Lista, IndexLo, InHi);
            }
            if (InLo < IndexHi) {
                Sorter.AbsoluteAscendQuickSort(Lista, InLo, IndexHi);
            }
        }
    }

    private static void AbsoluteDescendQuickSort(Sortable[] Lista, int IndexLo, int IndexHi) {
        int InLo = IndexLo;
        int InHi = IndexHi;
        if (IndexHi > IndexLo) {
            long ValorMedio = Lista[(IndexHi + IndexLo) / 2].Metrica();
            while (InLo <= InHi) {
                while (InLo < IndexHi && Lista[InLo].Metrica() > ValorMedio) {
                    ++InLo;
                }
                while (InHi > IndexLo && Lista[InHi].Metrica() < ValorMedio) {
                    --InHi;
                }
                if (InLo > InHi) continue;
                Sorter.Swap(Lista, InLo, InHi);
                ++InLo;
                --InHi;
            }
            if (IndexLo < InHi) {
                Sorter.AbsoluteDescendQuickSort(Lista, IndexLo, InHi);
            }
            if (InLo < IndexHi) {
                Sorter.AbsoluteDescendQuickSort(Lista, InLo, IndexHi);
            }
        }
    }

    private static void RelativeAscendQuickSort(Sortable[] Lista, int IndexLo, int IndexHi) {
        int InLo = IndexLo;
        int InHi = IndexHi;
        if (IndexHi > IndexLo) {
            Sortable Media = Lista[(IndexLo + IndexHi) / 2];
            while (InLo <= InHi) {
                while (Lista[InLo].Order(Media) < 0 && InLo < IndexHi) {
                    ++InLo;
                }
                while (Lista[InHi].Order(Media) > 0 && InHi > IndexLo) {
                    --InHi;
                }
                if (InLo > InHi) continue;
                Sorter.Swap(Lista, InLo, InHi);
                ++InLo;
                --InHi;
            }
            if (IndexLo < InHi) {
                Sorter.RelativeAscendQuickSort(Lista, IndexLo, InHi);
            }
            if (InLo < IndexHi) {
                Sorter.RelativeAscendQuickSort(Lista, InLo, IndexHi);
            }
        }
    }

    private static void RelativeDescendQuickSort(Sortable[] Lista, int IndexLo, int IndexHi) {
        int InLo = IndexLo;
        int InHi = IndexHi;
        if (IndexHi > IndexLo) {
            Sortable Media = Lista[(IndexLo + IndexHi) / 2];
            while (InLo <= InHi) {
                while (Lista[InLo].Order(Media) > 0 && InLo < IndexHi) {
                    ++InLo;
                }
                while (Lista[InHi].Order(Media) < 0 && InHi > IndexLo) {
                    --InHi;
                }
                if (InLo > InHi) continue;
                Sorter.Swap(Lista, InLo, InHi);
                ++InLo;
                --InHi;
            }
            if (IndexLo < InHi) {
                Sorter.RelativeDescendQuickSort(Lista, IndexLo, InHi);
            }
            if (InLo < IndexHi) {
                Sorter.RelativeDescendQuickSort(Lista, InLo, IndexHi);
            }
        }
    }

    private static void AbsoluteAscendQuickSortDouble(Sortable[] Lista, int IndexLo, int IndexHi) {
        int InLo = IndexLo;
        int InHi = IndexHi;
        if (IndexHi > IndexLo) {
            double ValorMedio = Lista[(IndexHi + IndexLo) / 2].MetricaDouble();
            while (InLo <= InHi) {
                while (InLo < IndexHi && Lista[InLo].MetricaDouble() < ValorMedio) {
                    ++InLo;
                }
                while (InHi > IndexLo && Lista[InHi].MetricaDouble() > ValorMedio) {
                    --InHi;
                }
                if (InLo > InHi) continue;
                Sorter.Swap(Lista, InLo, InHi);
                ++InLo;
                --InHi;
            }
            if (IndexLo < InHi) {
                Sorter.AbsoluteAscendQuickSortDouble(Lista, IndexLo, InHi);
            }
            if (InLo < IndexHi) {
                Sorter.AbsoluteAscendQuickSortDouble(Lista, InLo, IndexHi);
            }
        }
    }

    private static void AbsoluteDescendQuickSortDouble(Sortable[] Lista, int IndexLo, int IndexHi) {
        int InLo = IndexLo;
        int InHi = IndexHi;
        if (IndexHi > IndexLo) {
            double ValorMedio = Lista[(IndexHi + IndexLo) / 2].MetricaDouble();
            while (InLo <= InHi) {
                while (InLo < IndexHi && Lista[InLo].MetricaDouble() > ValorMedio) {
                    ++InLo;
                }
                while (InHi > IndexLo && Lista[InHi].MetricaDouble() < ValorMedio) {
                    --InHi;
                }
                if (InLo > InHi) continue;
                Sorter.Swap(Lista, InLo, InHi);
                ++InLo;
                --InHi;
            }
            if (IndexLo < InHi) {
                Sorter.AbsoluteDescendQuickSortDouble(Lista, IndexLo, InHi);
            }
            if (InLo < IndexHi) {
                Sorter.AbsoluteDescendQuickSortDouble(Lista, InLo, IndexHi);
            }
        }
    }

    private static void Swap(Sortable[] a, int i, int j) {
        Sortable T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    public static void AbsoluteSort(Sortable[] Lista, boolean Ascendente) {
        if (Ascendente) {
            Sorter.AbsoluteAscendQuickSort(Lista, 0, Lista.length - 1);
        } else {
            Sorter.AbsoluteDescendQuickSort(Lista, 0, Lista.length - 1);
        }
    }

    public static void AbsoluteSortDouble(Sortable[] Lista, boolean Ascendente) {
        if (Ascendente) {
            Sorter.AbsoluteAscendQuickSortDouble(Lista, 0, Lista.length - 1);
        } else {
            Sorter.AbsoluteDescendQuickSortDouble(Lista, 0, Lista.length - 1);
        }
    }

    public static void RelativeSort(Sortable[] Lista, boolean Ascendente) {
        if (Ascendente) {
            Sorter.RelativeAscendQuickSort(Lista, 0, Lista.length - 1);
        } else {
            Sorter.RelativeDescendQuickSort(Lista, 0, Lista.length - 1);
        }
    }
}

