/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.handler;

import com.valhalanetworks.utils.converters.Base64;
import com.valhalanetworks.utils.handler.VMessage;
import com.valhalanetworks.utils.kerneltasks.VTask;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VHandler
implements Runnable {
    private static final int QUEUESIZE = 1024;
    private static final long QUEUEWRITETIMEOUT = 100L;
    private static final long QUEUEREADTIMEOUT = 10L;
    private static final int DEFMAXIMUMPOOLSIZEKEEPALIVETIME = 5;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final LoggerManager vLog;
    private boolean Ejecutar;
    private long HandlerID;
    @GuardedBy(value="rwl")
    private PriorityBlockingQueue<VMessage> queue = null;
    private Thread Ejecutor = null;
    private String ControlKey = null;
    private RejectedExecutionHandlerImpl rejectionHandler = null;
    private ThreadFactory threadFactory = null;
    private ThreadPoolExecutor executorPool = null;
    private int ThreadCorePoolSize;
    private int MaxThreadCorePoolSize;
    private int NumCPUs;

    public VHandler() {
        this.vLog = null;
        this.MaxThreadCorePoolSize = this.NumCPUs = Runtime.getRuntime().availableProcessors();
        this.ThreadCorePoolSize = this.NumCPUs / 2;
        this.ThreadCorePoolSize = this.ThreadCorePoolSize > 0 ? this.ThreadCorePoolSize : 1;
        this.queue = new PriorityBlockingQueue(1024);
        this.StartThread();
    }

    public VHandler(LoggerManager vLog) {
        this.vLog = vLog;
        this.MaxThreadCorePoolSize = this.NumCPUs = Runtime.getRuntime().availableProcessors();
        this.ThreadCorePoolSize = this.NumCPUs / 2;
        this.ThreadCorePoolSize = this.ThreadCorePoolSize > 0 ? this.ThreadCorePoolSize : 1;
        this.queue = new PriorityBlockingQueue(1024);
        this.StartThread();
    }

    public VHandler(int Size, LoggerManager vLog) {
        this.vLog = vLog;
        this.MaxThreadCorePoolSize = this.NumCPUs = Runtime.getRuntime().availableProcessors();
        this.ThreadCorePoolSize = this.NumCPUs / 2;
        this.ThreadCorePoolSize = this.ThreadCorePoolSize > 0 ? this.ThreadCorePoolSize : 1;
        this.queue = Size < 1 ? new PriorityBlockingQueue(1024) : new PriorityBlockingQueue(Size);
        this.StartThread();
    }

    private final void StartThread() {
        this.Ejecutor = new Thread(this);
        MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
        this.HandlerID = Random2.nextLong63();
        this.Ejecutor.setName("Valhala_Handler[" + Long.toHexString(this.HandlerID) + "]");
        this.Ejecutor.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (VHandler.this.vLog != null) {
                    VHandler.this.vLog.LogMessage(2, 64, t.getName(), "Uncaught Exception\n" + e.toString());
                } else {
                    Logger.getLogger(t.getName()).log(Level.SEVERE, "Uncaught Exception\n" + e.toString());
                }
            }
        });
        this.Ejecutar = true;
        this.Ejecutor.start();
    }

    private final String KeyGenerator() {
        String Llave = null;
        MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
        byte[] BinaryKey = new byte[128];
        Random2.nextBytes(BinaryKey);
        try {
            Llave = Base64.encodeBytes(BinaryKey, 4);
        }
        catch (IOException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getName(), e.getMessage());
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
        }
        return Llave;
    }

    public final String getControlKey() {
        String Llave = this.KeyGenerator();
        if (this.ControlKey == null) {
            this.ControlKey = new String(Llave);
        }
        return Llave;
    }

    public final long getHandlerID() {
        return this.HandlerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendMessage(VMessage msg) {
        boolean Salida = false;
        if (msg != null) {
            this.rwl.writeLock().lock();
            try {
                Salida = this.queue.offer(msg, 100L, TimeUnit.MILLISECONDS);
            }
            catch (ClassCastException ex) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, VHandler.class.getName(), ex.getLocalizedMessage());
                } else {
                    Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                }
            }
            catch (NullPointerException ex) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, VHandler.class.getName(), ex.getLocalizedMessage());
                } else {
                    Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                }
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
        return Salida;
    }

    public final boolean sendMessageAtTime(VMessage msg, long uptimeMillis) {
        boolean Salida = false;
        if (msg != null) {
            DelayedRunManager DelayManager = new DelayedRunManager(msg, uptimeMillis, this.vLog);
            Salida = this.Post(DelayManager);
        }
        return Salida;
    }

    public final boolean sendMessageDelayed(VMessage msg, long delayMillis) {
        long currentTime = System.currentTimeMillis();
        return this.sendMessageAtTime(msg, delayMillis + currentTime);
    }

    public final boolean Post(VTask r) {
        VMessage Mensaje = null;
        boolean Salida = false;
        if (r != null) {
            Mensaje = new VMessage();
            Mensaje.Ejecutable = r;
            Mensaje.setPriority(r.getPriority());
            Salida = this.sendMessage(Mensaje);
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 32, this.getClass().getName(), "VTask is NULL");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "VTask is NULL");
        }
        return Salida;
    }

    public final boolean postAtTime(VTask r, long uptimeMillis) {
        VMessage Mensaje = null;
        boolean Salida = false;
        if (r != null) {
            Mensaje = new VMessage();
            Mensaje.Ejecutable = r;
            Mensaje.setPriority(r.getPriority());
            Salida = this.sendMessageAtTime(Mensaje, uptimeMillis);
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 32, this.getClass().getName(), "VTask is NULL");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "VTask is NULL");
        }
        return Salida;
    }

    public final boolean postDelayed(VTask r, long delayMillis) {
        VMessage Mensaje = null;
        boolean Salida = false;
        if (r != null) {
            Mensaje = new VMessage();
            Mensaje.Ejecutable = r;
            Mensaje.setPriority(r.getPriority());
            Salida = this.sendMessageDelayed(Mensaje, delayMillis);
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 32, this.getClass().getName(), "VTask is NULL");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "VTask is NULL");
        }
        return Salida;
    }

    public static final VMessage getEmptyMessage() {
        VMessage Mensaje = null;
        Mensaje = new VMessage();
        return Mensaje;
    }

    public final VMessage getReturnableEmptyMessage() {
        VMessage Mensaje = null;
        Mensaje = new VMessage(this);
        return Mensaje;
    }

    public final void Clear(String CtrlKey) {
        if (this.Ejecutor != null) {
            if (this.vLog != null) {
                this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Message Queue Cleaned");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Message Queue Cleaned");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(1, 16, VHandler.class.getName(), "Message Queue Cleaned");
        } else {
            Logger.getLogger(VHandler.class.getName()).log(Level.INFO, "Message Queue Cleaned");
        }
        if (this.ControlKey == null || this.ControlKey.equals(CtrlKey)) {
            this.rwl.writeLock().lock();
            try {
                this.queue.clear();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 32, VHandler.class.getName(), "Message Queue Clean Failed due Control Key MISMATCH");
        } else {
            Logger.getLogger(VHandler.class.getName()).log(Level.WARNING, "Message Queue Clean Failed due Control Key MISMATCH");
        }
    }

    public final void Shutdown(String CtrlKey) {
        if (this.Ejecutor != null) {
            if (this.vLog != null) {
                this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Shutdown Started");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Shutdown Started");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(1, 16, VHandler.class.getName(), "Shutdown Started");
        } else {
            Logger.getLogger(VHandler.class.getName()).log(Level.INFO, "Shutdown Started");
        }
        if (this.ControlKey == null || this.ControlKey.equals(CtrlKey)) {
            this.rwl.writeLock().lock();
            try {
                this.Ejecutar = false;
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 32, VHandler.class.getName(), "Shutdown Failed due Control Key MISMATCH");
        } else {
            Logger.getLogger(VHandler.class.getName()).log(Level.WARNING, "Shutdown Failed due Control Key MISMATCH");
        }
    }

    protected final void finalize() throws Throwable {
        if (this.Ejecutor != null) {
            if (this.vLog != null) {
                this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Finalize Started");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Finalize Started");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(1, 16, VHandler.class.getName(), "Finalize Started");
        } else {
            Logger.getLogger(VHandler.class.getName()).log(Level.INFO, "Finalize Started");
        }
        this.rwl.writeLock().lock();
        try {
            this.Ejecutar = false;
        }
        finally {
            this.rwl.writeLock().unlock();
            super.finalize();
        }
    }

    public void handleMessage(VMessage msg) {
        if (this.vLog != null) {
            this.vLog.LogMessage(2, 64, this.getClass().getName(), "Method handleMessage(VMessage msg) NEED to be Override by Subclasses at VHandler[" + Long.toHexString(this.HandlerID) + "]");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Method handleMessage(VMessage msg) NEED to be Override by Subclasses at VHandler[" + Long.toHexString(this.HandlerID) + "]");
        }
        throw new UnsupportedOperationException("Method handleMessage(VMessage msg) NEED to be Override by Subclasses at VHandler[" + Long.toHexString(this.HandlerID) + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean LEjecutar;
        VMessage Mensaje = null;
        if (this.Ejecutor != null) {
            if (this.vLog != null) {
                this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "VHandler Started");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "VHandler Started");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(1, 16, VHandler.class.getName(), "VHandler Started");
        } else {
            Logger.getLogger(VHandler.class.getName()).log(Level.INFO, "VHandler Started");
        }
        this.rejectionHandler = new RejectedExecutionHandlerImpl();
        this.threadFactory = Executors.defaultThreadFactory();
        this.executorPool = new ThreadPoolExecutor(this.ThreadCorePoolSize, this.MaxThreadCorePoolSize, 5L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(10 * this.MaxThreadCorePoolSize), this.threadFactory, this.rejectionHandler);
        this.executorPool.allowCoreThreadTimeOut(true);
        this.rwl.readLock().lock();
        try {
            LEjecutar = this.Ejecutar;
        }
        finally {
            this.rwl.readLock().unlock();
        }
        while (LEjecutar) {
            this.rwl.readLock().lock();
            try {
                Mensaje = this.queue.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, VHandler.class.getName(), ex.getLocalizedMessage());
                } else {
                    Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                }
            }
            finally {
                this.rwl.readLock().unlock();
            }
            if (Mensaje != null) {
                if (Mensaje.Ejecutable == null) {
                    this.handleMessage(Mensaje);
                } else {
                    this.executorPool.execute(Mensaje.Ejecutable);
                }
            }
            this.rwl.readLock().lock();
            try {
                LEjecutar = this.Ejecutar;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
        this.rwl.writeLock().lock();
        try {
            this.queue.clear();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        try {
            if (this.executorPool != null) {
                this.executorPool.shutdown();
                if (this.executorPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Thread Pool Finished");
                    } else {
                        Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Thread Pool Finished");
                    }
                } else {
                    this.executorPool.shutdownNow();
                    if (this.executorPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                        if (this.vLog != null) {
                            this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "Thread Pool Forced to Finished");
                        } else {
                            Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Thread Pool Forced to Finished");
                        }
                    } else if (this.vLog != null) {
                        this.vLog.LogMessage(1, 32, this.Ejecutor.getName(), "Thread Pool NO Finished before TimeOut");
                    } else {
                        Logger.getLogger(this.Ejecutor.getName()).log(Level.WARNING, "Thread Pool NO Finished before TimeOut");
                    }
                }
            } else if (this.vLog != null) {
                this.vLog.LogMessage(2, 32, this.Ejecutor.getName(), "Thread Pool is NULL");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.WARNING, "Thread Pool is NULL");
            }
        }
        catch (InterruptedException ex) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.Ejecutor.getName(), ex.getMessage());
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        catch (SecurityException ex) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.Ejecutor.getName(), ex.getMessage());
            }
            Logger.getLogger(this.Ejecutor.getName()).log(Level.SEVERE, ex.getMessage());
        }
        if (this.Ejecutor != null) {
            if (this.vLog != null) {
                this.vLog.LogMessage(1, 16, this.Ejecutor.getName(), "VHandler Stopped");
            } else {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "VHandler Stopped");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(1, 16, VHandler.class.getName(), "VHandler Stopped");
        } else {
            Logger.getLogger(VHandler.class.getName()).log(Level.INFO, "VHandler Stopped");
        }
    }

    private final class DelayedRunManager
    extends VTask {
        private static final int MAXDELAY = 1000;
        private long uptimeMillis;
        private VMessage msg;
        private MersenneTwisterPlus Random;

        public DelayedRunManager(VMessage msg, long uptimeMillis, LoggerManager vLog) {
            super(vLog);
            this.uptimeMillis = uptimeMillis;
            this.msg = msg;
            this.setPriority(msg.getPriority());
        }

        public long getUptimeMillis() {
            return this.uptimeMillis;
        }

        public void setUptimeMillis(long uptimeMillis) {
            this.uptimeMillis = uptimeMillis;
        }

        public VMessage getMsg() {
            return this.msg;
        }

        public void setMsg(VMessage msg) {
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.Random = new MersenneTwisterPlus();
            long currentTime = System.currentTimeMillis();
            long delay = this.uptimeMillis - currentTime;
            if (delay > 1000L) {
                double queueEmptyPercent;
                VHandler.this.rwl.readLock().lock();
                try {
                    delay = VHandler.this.executorPool.getPoolSize();
                    if (delay <= 0L) {
                        delay = 1L;
                    }
                    queueEmptyPercent = 1.0 - (double)VHandler.this.queue.size() / (double)(VHandler.this.queue.remainingCapacity() + VHandler.this.queue.size()) * ((double)VHandler.this.executorPool.getActiveCount() / (double)delay);
                }
                finally {
                    VHandler.this.rwl.readLock().unlock();
                }
                if (queueEmptyPercent > 0.0) {
                    delay = (long)(1000.0 * queueEmptyPercent);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex) {
                        if (vLogM != null) {
                            vLogM.LogMessage(2, 64, VHandler.class.getName(), ex.getLocalizedMessage());
                        }
                        Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                    }
                }
                while (!VHandler.this.Post(this)) {
                    if (vLogM != null) {
                        vLogM.LogMessage(2, 64, VHandler.class.getName(), "Messaje Delay Manager CAN'T be send at time  " + Long.toString(currentTime) + " milliSeconds");
                    } else {
                        Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, "Messaje Delay Manager CAN'T be send at time  " + Long.toString(currentTime) + " milliSeconds");
                    }
                    try {
                        delay = this.Random.nextInt(50);
                        if (vLogM != null) {
                            vLogM.LogMessage(2, 16, VHandler.class.getName(), "Waiting " + Long.toString(delay) + " milliSeconds to try to send the Messaje Delay Manager again");
                        } else {
                            Logger.getLogger(VHandler.class.getName()).log(Level.INFO, "Waiting " + Long.toString(delay) + " milliSeconds to try to send the Messaje Delay Manager again");
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex) {
                        if (vLogM != null) {
                            vLogM.LogMessage(2, 64, VHandler.class.getName(), ex.getLocalizedMessage());
                            continue;
                        }
                        Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                    }
                }
            } else {
                if (delay > 0L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex) {
                        if (vLogM != null) {
                            vLogM.LogMessage(2, 64, VHandler.class.getName(), ex.getLocalizedMessage());
                        }
                        Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                    }
                }
                while (!VHandler.this.sendMessage(this.msg)) {
                    if (vLogM != null) {
                        vLogM.LogMessage(2, 64, VHandler.class.getName(), "Messaje CAN'T be send at time  " + Long.toString(this.uptimeMillis) + " milliSeconds");
                    } else {
                        Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, "Messaje CAN'T be send at time  " + Long.toString(this.uptimeMillis) + " milliSeconds");
                    }
                    try {
                        delay = this.Random.nextInt(50);
                        if (vLogM != null) {
                            vLogM.LogMessage(2, 16, VHandler.class.getName(), "Waiting " + Long.toString(delay) + " milliSeconds to try to send the Messaje again");
                        } else {
                            Logger.getLogger(VHandler.class.getName()).log(Level.INFO, "Waiting " + Long.toString(delay) + " milliSeconds to try to send the Messaje again");
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex) {
                        if (vLogM != null) {
                            vLogM.LogMessage(2, 64, VHandler.class.getName(), ex.getLocalizedMessage());
                            continue;
                        }
                        Logger.getLogger(VHandler.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private final class RejectedExecutionHandlerImpl
    implements RejectedExecutionHandler {
        private RejectedExecutionHandlerImpl() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            int PoolSize = executor.getPoolSize();
            int CorePoolSize = executor.getCorePoolSize();
            int ActiveCount = executor.getActiveCount();
            long CompletedTaskCount = executor.getCompletedTaskCount();
            long TaskCount = executor.getTaskCount();
            boolean Shutdown = executor.isShutdown();
            boolean Terminated = executor.isTerminated();
            if (VHandler.this.vLog != null) {
                VHandler.this.vLog.LogMessage(2, 64, r.getClass().getName(), "Rejected to be executed by " + VHandler.class.getName());
                VHandler.this.vLog.LogMessage(2, 16, r.getClass().getName(), String.format("[%s monitor] [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s", VHandler.class.getName(), PoolSize, CorePoolSize, ActiveCount, CompletedTaskCount, TaskCount, Shutdown, Terminated));
            } else {
                Logger.getLogger(r.getClass().getName()).log(Level.SEVERE, "Rejected to be executed by " + VHandler.class.getName());
                Logger.getLogger(r.getClass().getName()).log(Level.INFO, String.format("[%s monitor] [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s", VHandler.class.getName(), PoolSize, CorePoolSize, ActiveCount, CompletedTaskCount, TaskCount, Shutdown, Terminated));
            }
            if (VTask.class.isInstance(r)) {
                if (VHandler.this.Post((VTask)r)) {
                    if (VHandler.this.vLog != null) {
                        VHandler.this.vLog.LogMessage(2, 16, r.getClass().getName(), "Rescheduled to be executed by " + VHandler.class.getName());
                    } else {
                        Logger.getLogger(r.getClass().getName()).log(Level.INFO, "Rescheduled to be executed by " + VHandler.class.getName());
                    }
                } else if (VHandler.this.vLog != null) {
                    VHandler.this.vLog.LogMessage(2, 64, r.getClass().getName(), "Rejected to be rescheduled by " + VHandler.class.getName());
                } else {
                    Logger.getLogger(r.getClass().getName()).log(Level.SEVERE, "Rejected to be rescheduled by " + VHandler.class.getName());
                }
            } else if (VHandler.this.vLog != null) {
                VHandler.this.vLog.LogMessage(2, 64, this.getClass().getName(), "Rejected Task " + r.getClass().getName() + " IS NOT VTask Class");
            } else {
                Logger.getLogger(r.getClass().getName()).log(Level.SEVERE, "Rejected Task " + r.getClass().getName() + " IS NOT VTask Class");
            }
        }
    }
}

