/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.environment;

import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.converters.Base64;
import com.valhalanetworks.utils.converters.Converter;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.files.FileManager;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnvironmentUtils {
    private EnvironmentUtils() {
    }

    public static boolean CheckJavaVersion(String JREVersion) {
        int Update;
        boolean Salida = false;
        StringBuffer Version = new StringBuffer(System.getProperty("java.version"));
        int Rev = Version.indexOf(".");
        int Ver = Integer.valueOf(Version.substring(0, Rev));
        int Comp = Version.indexOf(".", ++Rev);
        Rev = Integer.valueOf(Version.substring(Rev, Comp));
        if ((Update = Version.indexOf("_", ++Comp)) != -1) {
            Comp = Integer.valueOf(Version.substring(Comp, Update));
            ++Update;
            Update = Integer.valueOf(Version.substring(Update));
        } else {
            Comp = Integer.valueOf(Version.substring(Comp, Version.length()));
            Update = 0;
        }
        Version = new StringBuffer(JREVersion);
        int rRev = Version.indexOf(".");
        int rVer = Integer.valueOf(Version.substring(0, rRev));
        int rComp = Version.indexOf(".", ++rRev);
        rRev = Integer.valueOf(Version.substring(rRev, rComp));
        int rUpdate = Version.indexOf("_", ++rComp);
        if (rUpdate != -1) {
            rComp = Integer.valueOf(Version.substring(rComp, rUpdate));
            ++rUpdate;
            rUpdate = Integer.valueOf(Version.substring(rUpdate));
        } else {
            rComp = Integer.valueOf(Version.substring(rComp, Version.length()));
            rUpdate = 0;
        }
        if (Ver > rVer) {
            Salida = true;
        } else if (Ver == rVer && Rev > rRev) {
            Salida = true;
        } else if (Ver == rVer && Rev == rRev && Comp > rComp) {
            Salida = true;
        } else if (Ver == rVer && Rev == rRev && Comp == rComp && Update > rUpdate) {
            Salida = true;
        } else if (Ver == rVer && Rev == rRev && Comp == rComp && Update == rUpdate) {
            Salida = true;
        }
        return Salida;
    }

    public static String getEncoding() {
        return System.getProperty("file.encoding").toLowerCase(Locale.ENGLISH);
    }

    public static String getOS() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    }

    public static String getArch() {
        return System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
    }

    public static String getPathToJarfileDir(Class classToUse) {
        File F;
        URL url;
        try {
            url = classToUse.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException ex) {
            url = classToUse.getResource(classToUse.getSimpleName() + ".class");
        }
        String extURL = url.toExternalForm();
        if (extURL.endsWith(".jar")) {
            extURL = extURL.substring(0, extURL.lastIndexOf("/"));
        } else {
            String suffix = "/" + classToUse.getName().replace(".", "/") + ".class";
            if ((extURL = extURL.replace(suffix, "")).startsWith("jar:") && extURL.endsWith(".jar!")) {
                extURL = extURL.substring(4, extURL.lastIndexOf("/"));
            }
        }
        try {
            url = new URL(extURL);
        }
        catch (MalformedURLException suffix) {
            // empty catch block
        }
        try {
            F = new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            F = new File(url.getPath());
        }
        return F.getAbsolutePath();
    }

    public static String getMotherboardSN(LoggerManager vLog) {
        String result;
        block21: {
            result = null;
            MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
            String OS = EnvironmentUtils.getOS();
            String Arch = EnvironmentUtils.getArch();
            if (OS != null && OS.toLowerCase(new Locale("en")).contains("windows")) {
                try {
                    result = new String();
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "c:\\Windows\\Temp\\" + Converter.byte2StringHex(BTemp) + ".vbs";
                    FileManager file = new FileManager(line);
                    String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("cscript //NoLogo " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        result = result + line;
                    }
                    file.Wipe();
                    result = result.trim();
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                        break block21;
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            } else if (OS != null && OS.toLowerCase(new Locale("en")).contains("linux") && (Arch.toLowerCase(new Locale("en")).contains("i386") || Arch.toLowerCase(new Locale("en")).contains("amd64"))) {
                try {
                    result = new String();
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "/tmp/" + Converter.byte2StringHex(BTemp) + ".sh";
                    FileManager file = new FileManager(line);
                    String vbs = "#!/bin/sh\nsudo dmidecode -s system-serial-number\n\n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("sh " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        result = result + line;
                    }
                    file.Wipe();
                    result = result.trim();
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                        break block21;
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            } else if (OS != null && OS.toLowerCase(new Locale("en")).contains("linux") && Arch.toLowerCase(new Locale("en")).contains("arm")) {
                try {
                    int j;
                    result = new String();
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "/tmp/" + Converter.byte2StringHex(BTemp) + ".sh";
                    FileManager file = new FileManager(line);
                    String vbs = "#!/bin/sh\ngrep Serial /proc/cpuinfo | cut -d \" \" -f 2\n\n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("sh " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        result = result + line;
                    }
                    file.Wipe();
                    result = result.trim();
                    BTemp = Converter.StringHex2bytes(result);
                    for (j = 0; j < BTemp.length && BTemp[j] == 0; ++j) {
                    }
                    if (j < BTemp.length) {
                        int i = 0;
                        while (j < BTemp.length) {
                            BTemp[i] = BTemp[j];
                            ++j;
                            ++i;
                        }
                        BTemp = (byte[])ArrayUtils.resizeArray(BTemp, i);
                        result = Converter.byte2StringHex(BTemp);
                    } else {
                        result = null;
                    }
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            }
        }
        return result;
    }

    public static String getHDDSerialNumber(String drive, LoggerManager vLog) {
        String result;
        block22: {
            result = null;
            MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
            String OS = EnvironmentUtils.getOS();
            String Arch = EnvironmentUtils.getArch();
            if (OS != null && OS.toLowerCase(new Locale("en")).contains("windows")) {
                try {
                    result = new String();
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "c:\\Windows\\Temp\\" + Converter.byte2StringHex(BTemp) + ".vbs";
                    FileManager file = new FileManager(line);
                    if (drive.length() > 1) {
                        drive = drive.substring(0, 1);
                    }
                    String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive.toUpperCase(new Locale("en")) + "\")\n" + "Wscript.Echo objDrive.SerialNumber";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("cscript //NoLogo " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        result = result + line;
                    }
                    file.Wipe();
                    int[] Serial = new int[]{Integer.parseInt(result, 10)};
                    BTemp = Converter.int2byte(Serial);
                    result = Converter.byte2StringHex(BTemp);
                    result = result.trim();
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                        break block22;
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            } else if (OS != null && OS.toLowerCase(new Locale("en")).contains("linux") && (Arch.toLowerCase(new Locale("en")).contains("i386") || Arch.toLowerCase(new Locale("en")).contains("amd64"))) {
                try {
                    result = new String();
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "/tmp/" + Converter.byte2StringHex(BTemp) + ".sh";
                    FileManager file = new FileManager(line);
                    String vbs = "#!/bin/sh\nudevadm info --query=property --name=" + drive.toLowerCase(new Locale("en")) + " | grep ID_SERIAL= | awk -F '=' '{ print $2}'\n" + "\n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("sh " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        result = result + line;
                    }
                    file.Wipe();
                    result = result.trim();
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                        break block22;
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            } else if (OS != null && OS.toLowerCase(new Locale("en")).contains("linux") && Arch.toLowerCase(new Locale("en")).contains("arm")) {
                try {
                    int j;
                    result = new String();
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "/tmp/" + Converter.byte2StringHex(BTemp) + ".sh";
                    FileManager file = new FileManager(line);
                    String vbs = "#!/bin/sh\ncat /sys/block/mmcblk0/device/cid\n\n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("sh " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        result = result + line;
                    }
                    file.Wipe();
                    result = result.trim();
                    BTemp = Converter.StringHex2bytes(result);
                    for (j = 0; j < BTemp.length && BTemp[j] == 0; ++j) {
                    }
                    if (j < BTemp.length) {
                        int i = 0;
                        while (j < BTemp.length) {
                            BTemp[i] = BTemp[j];
                            ++j;
                            ++i;
                        }
                        BTemp = (byte[])ArrayUtils.resizeArray(BTemp, i);
                        result = Converter.byte2StringHex(BTemp);
                    } else {
                        result = null;
                    }
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            }
        }
        return result;
    }

    public static String[] getHDDs(LoggerManager vLog) {
        String[] Salida;
        block23: {
            Salida = null;
            Object[] result = null;
            MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
            String OS = EnvironmentUtils.getOS();
            String Arch = EnvironmentUtils.getArch();
            if (OS != null && OS.toLowerCase(new Locale("en")).contains("windows")) {
                try {
                    int i;
                    result = new String[100];
                    for (i = 0; i < result.length; ++i) {
                        result[i] = null;
                    }
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "c:\\Windows\\Temp\\" + Converter.byte2StringHex(BTemp) + ".vbs";
                    FileManager file = new FileManager(line);
                    String vbs = "Dim goFS      : Set goFS      = CreateObject( \"Scripting.FileSystemObject\" )\nDim dicDTypes : Set dicDTypes = buildDicMKV( vbTextCompare, Split( \"0 1 2 3 4 5\" ), Split( \"Unknown Removable Fixed Network CD-ROM RAM-Disk\" ))\nDim dicDrives : Set dicDrives = CreateObject( \"Scripting.Dictionary\" )\nDim oWSH      : Set oWSH      = CreateObject( \"WScript.Shell\" )\nDim oDrive\nFor Each oDrive In goFS.Drives\nIf \"Fixed\" = dicDTypes( CStr( oDrive.DriveType ) ) And sSDLetter <> oDrive.DriveLetter Then\nSet dicDrives( oDrive.DriveLetter ) = oDrive\nEnd If\nNext\nDim sDrive\nFor Each sDrive In dicDrives.Keys\nSet oDrive = dicDrives( sDrive )\nWScript.Echo oDrive.DriveLetter\nNext\n\nFunction buildDicMKV( vbCompMode, aKeys, aValues )\nSet buildDicMKV = CreateObject( \"Scripting.Dictionary\" )\nbuildDicMKV.CompareMode = vbCompMode\nDim nIdx\nFor nIdx = 0 To UBound( aKeys )\nbuildDicMKV.Add aKeys( nIdx ), aValues( nIdx )\nNext\nEnd Function\n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("cscript //NoLogo " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    for (i = 0; (line = input.readLine()) != null && i < result.length; ++i) {
                        result[i] = line;
                    }
                    file.Wipe();
                    if (i > 0) {
                        Salida = (String[])ArrayUtils.arrayTrim(result);
                    }
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                        break block23;
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            } else if (OS != null && OS.toLowerCase(new Locale("en")).contains("linux") && (Arch.toLowerCase(new Locale("en")).contains("i386") || Arch.toLowerCase(new Locale("en")).contains("amd64"))) {
                try {
                    int i;
                    result = new String[100];
                    for (i = 0; i < result.length; ++i) {
                        result[i] = null;
                    }
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "/tmp/" + Converter.byte2StringHex(BTemp) + ".sh";
                    FileManager file = new FileManager(line);
                    String vbs = "#!/bin/sh\ndf -h | grep /dev/ | awk -F '/' '{ print substr ($3, 0, 3)}' | sort -u\n\n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("sh " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    for (i = 0; (line = input.readLine()) != null && i < result.length; ++i) {
                        result[i] = line;
                    }
                    file.Wipe();
                    if (i > 0) {
                        Salida = (String[])ArrayUtils.arrayTrim(result);
                    }
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                        break block23;
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            } else if (OS != null && OS.toLowerCase(new Locale("en")).contains("linux") && Arch.toLowerCase(new Locale("en")).contains("arm")) {
                try {
                    int i;
                    result = new String[100];
                    for (i = 0; i < result.length; ++i) {
                        result[i] = null;
                    }
                    byte[] BTemp = new byte[20];
                    Random2.nextBytes(BTemp);
                    String line = "/tmp/" + Converter.byte2StringHex(BTemp) + ".sh";
                    FileManager file = new FileManager(line);
                    String vbs = "#!/bin/sh\ndf -h | grep /dev/ | grep -v root | awk -F '/' '{ print substr ($3, 0, 8)}' | sort -u\n\n";
                    file.Open(1);
                    file.Write(vbs.getBytes("UTF-8"));
                    file.Close();
                    Process proc = Runtime.getRuntime().exec("sh " + file.getAbsoluteFilePath());
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    for (i = 0; (line = input.readLine()) != null && i < result.length; ++i) {
                        result[i] = line;
                    }
                    file.Wipe();
                    if (i > 0) {
                        Salida = (String[])ArrayUtils.arrayTrim(result);
                    }
                }
                catch (UtilsException | IOException e) {
                    if (vLog != null) {
                        vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), e.getLocalizedMessage());
                    }
                    Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, e);
                }
            }
        }
        return Salida;
    }

    public static String[] getMACs(LoggerManager vLog) {
        Object[] MACs = null;
        try {
            int NumMACs;
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            if (networks.hasMoreElements()) {
                MACs = new String[100];
                for (NumMACs = 0; NumMACs < MACs.length; ++NumMACs) {
                    MACs[NumMACs] = null;
                }
            }
            NumMACs = 0;
            while (networks.hasMoreElements() && NumMACs < MACs.length) {
                byte[] MAC;
                NetworkInterface network = networks.nextElement();
                if (network.isVirtual() || network.isLoopback() || (MAC = network.getHardwareAddress()) == null || MAC.length != 6) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < MAC.length; ++i) {
                    sb.append(String.format("%02X%s", MAC[i], i < MAC.length - 1 ? "-" : ""));
                }
                MACs[NumMACs] = sb.toString();
                ++NumMACs;
            }
            if (NumMACs < MACs.length) {
                MACs = (String[])ArrayUtils.arrayTrim(MACs);
            }
        }
        catch (SocketException ex) {
            if (vLog != null) {
                vLog.LogMessage(2, 64, EnvironmentUtils.class.getSimpleName(), ex.getLocalizedMessage());
            }
            Logger.getLogger(EnvironmentUtils.class.getSimpleName()).log(Level.SEVERE, null, ex);
        }
        return MACs;
    }

    public static String getValhalaHwID(LoggerManager vLog) {
        int Group;
        int Pos;
        int i;
        String Salida = null;
        StringBuffer Mexclador = null;
        String[] HDDs = null;
        String HDDSerial = null;
        String[] MACs = EnvironmentUtils.getMACs(vLog);
        String MBSerial = EnvironmentUtils.getMotherboardSN(vLog);
        String OS = EnvironmentUtils.getOS();
        if (OS != null && OS.toLowerCase(new Locale("en")).contains("windows")) {
            HDDs = EnvironmentUtils.getHDDs(vLog);
            if (HDDs != null) {
                HDDSerial = "";
                for (i = 0; i < HDDs.length; ++i) {
                    HDDSerial = HDDSerial + EnvironmentUtils.getHDDSerialNumber(HDDs[i], vLog);
                }
            } else {
                HDDSerial = EnvironmentUtils.getHDDSerialNumber("C", vLog);
            }
        } else if (OS != null && OS.toLowerCase(new Locale("en")).contains("linux")) {
            HDDs = EnvironmentUtils.getHDDs(vLog);
            if (HDDs != null) {
                HDDSerial = "";
                for (i = 0; i < HDDs.length; ++i) {
                    HDDSerial = HDDSerial + EnvironmentUtils.getHDDSerialNumber(HDDs[i], vLog);
                }
            } else {
                HDDSerial = EnvironmentUtils.getHDDSerialNumber("sda", vLog);
            }
        }
        if (MBSerial != null) {
            Mexclador = new StringBuffer();
            block17: for (Pos = 0; Pos < MBSerial.length(); ++Pos) {
                Group = (MBSerial.charAt(Pos) + Pos + Mexclador.length()) % 3;
                switch (Group) {
                    case 0: {
                        Mexclador.append((char)((MBSerial.charAt(Pos) + Pos + Mexclador.length()) % 10 + 48));
                        continue block17;
                    }
                    case 1: {
                        Mexclador.append((char)((MBSerial.charAt(Pos) + Pos + Mexclador.length()) % 25 + 97));
                        continue block17;
                    }
                    case 2: {
                        Mexclador.append((char)((MBSerial.charAt(Pos) + Pos + Mexclador.length()) % 25 + 65));
                        continue block17;
                    }
                    default: {
                        Mexclador.append((char)((MBSerial.charAt(Pos) + Pos + Mexclador.length()) % 25 + 65));
                    }
                }
            }
        }
        if (HDDSerial != null) {
            if (Mexclador == null) {
                Mexclador = new StringBuffer();
            }
            block18: for (Pos = 0; Pos < HDDSerial.length(); ++Pos) {
                Group = (HDDSerial.charAt(Pos) + Pos + Mexclador.length()) % 3;
                switch (Group) {
                    case 0: {
                        Mexclador.append((char)((HDDSerial.charAt(Pos) + Pos + Mexclador.length()) % 10 + 48));
                        continue block18;
                    }
                    case 1: {
                        Mexclador.append((char)((HDDSerial.charAt(Pos) + Pos + Mexclador.length()) % 25 + 97));
                        continue block18;
                    }
                    case 2: {
                        Mexclador.append((char)((HDDSerial.charAt(Pos) + Pos + Mexclador.length()) % 25 + 65));
                        continue block18;
                    }
                    default: {
                        Mexclador.append((char)((HDDSerial.charAt(Pos) + Pos + Mexclador.length()) % 25 + 65));
                    }
                }
            }
        }
        if (MACs != null) {
            if (Mexclador == null) {
                Mexclador = new StringBuffer();
            }
            for (i = 0; i < MACs.length; ++i) {
                block20: for (Pos = 0; Pos < MACs[i].length(); ++Pos) {
                    if (MACs[i].charAt(Pos) == '-') {
                        Mexclador.append((char)((Pos + i + Mexclador.length()) % 25 + 65));
                        continue;
                    }
                    Group = (MACs[i].charAt(Pos) + i + Pos + Mexclador.length()) % 3;
                    switch (Group) {
                        case 0: {
                            Mexclador.append((char)((MACs[i].charAt(Pos) + i + Pos + Mexclador.length()) % 10 + 48));
                            continue block20;
                        }
                        case 1: {
                            Mexclador.append((char)((MACs[i].charAt(Pos) + i + Pos + Mexclador.length()) % 25 + 97));
                            continue block20;
                        }
                        case 2: {
                            Mexclador.append((char)((MACs[i].charAt(Pos) + i + Pos + Mexclador.length()) % 25 + 65));
                            continue block20;
                        }
                        default: {
                            Mexclador.append((char)((MACs[i].charAt(Pos) + i + Pos + Mexclador.length()) % 25 + 65));
                        }
                    }
                }
            }
        }
        if (Mexclador != null) {
            Salida = Mexclador.toString();
        }
        return Salida;
    }

    public static String genSALT(LoggerManager vLog) throws IOException {
        StringBuffer Salida = null;
        String VHwID = null;
        String randomID = null;
        MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
        VHwID = EnvironmentUtils.getValhalaHwID(vLog);
        byte[] binRandomID = new byte[VHwID.length()];
        Random2.nextBytes(binRandomID);
        randomID = Base64.encodeBytes(binRandomID, 4);
        if (randomID != null && VHwID != null) {
            Salida = new StringBuffer();
            if (randomID.length() > VHwID.length()) {
                int Salto = randomID.length() / VHwID.length();
                if (Salto == 0) {
                    Salto = 1;
                }
                int Pos2 = 0;
                for (int Pos = 0; Pos < randomID.length(); ++Pos) {
                    int Isrt;
                    if (Pos2 < VHwID.length() && (Isrt = Pos % Salto) == 0) {
                        Salida.append(VHwID.charAt(Pos2));
                        ++Pos2;
                    }
                    Salida.append(randomID.charAt(Pos));
                }
            } else {
                int Salto = VHwID.length() / randomID.length();
                if (Salto == 0) {
                    Salto = 1;
                }
                int Pos2 = 0;
                for (int Pos = 0; Pos < VHwID.length(); ++Pos) {
                    int Isrt;
                    if (Pos2 < randomID.length() && (Isrt = Pos % Salto) == 0) {
                        Salida.append(randomID.charAt(Pos2));
                        ++Pos2;
                    }
                    Salida.append(VHwID.charAt(Pos));
                }
            }
        } else {
            Salida = new StringBuffer(randomID);
        }
        return Salida.toString();
    }
}

