/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.console;

public class ProgressBar {
    private int Progress = 0;
    private int RotorPos = 0;
    private int MaxChars = 79;
    private boolean FirstTime = true;
    private char BarChar = (char)61;
    private char[] Rotor = new char[4];
    private long Plot_Start_Time = -1L;
    private long Plot_End_Time = -1L;

    public ProgressBar() {
        this.setStandarRotor();
    }

    public final void setStandarRotor() {
        this.Rotor[0] = 45;
        this.Rotor[1] = 92;
        this.Rotor[2] = 124;
        this.Rotor[3] = 47;
    }

    public final void setCustomRotor(char[] NewRotor) {
        if (NewRotor != null && NewRotor.length == 4) {
            for (int i = 0; i < 4; ++i) {
                this.Rotor[i] = NewRotor[i];
            }
        }
    }

    public String ResetProgressBar() {
        this.FirstTime = true;
        String Salida = "\r";
        Salida = Salida + this.DrawRotor() + " [";
        for (int i = 0; i < this.MaxChars - 9; ++i) {
            Salida = Salida + " ";
        }
        Salida = Salida + "] ";
        Salida = Salida + "0%  \r";
        return Salida;
    }

    public void setMaxChars(int MaxChars) {
        if (MaxChars > 15) {
            this.MaxChars = MaxChars;
        }
    }

    public void setBarChar(char BarChar) {
        this.BarChar = BarChar;
    }

    public String DrawRotor() {
        switch (this.RotorPos) {
            case 0: {
                ++this.RotorPos;
                return "\b" + this.Rotor[0];
            }
            case 1: {
                ++this.RotorPos;
                return "\b" + this.Rotor[1];
            }
            case 2: {
                ++this.RotorPos;
                return "\b" + this.Rotor[2];
            }
            case 3: {
                this.RotorPos = 0;
                return "\b" + this.Rotor[3];
            }
        }
        this.RotorPos = 0;
        return "\b" + this.Rotor[0];
    }

    public String DrawProgressBar(int Porcent) {
        String Salida = "";
        if (Porcent >= 0 && Porcent <= 100) {
            if (this.FirstTime) {
                this.FirstTime = false;
                Salida = "\r";
                Salida = Salida + this.DrawRotor() + " [";
                for (int i = 0; i < this.MaxChars - 9; ++i) {
                    Salida = Salida + " ";
                }
                Salida = Salida + "] ";
                Salida = Salida + "0%  \r";
            } else if (Porcent != this.Progress) {
                int i;
                Salida = Salida + this.DrawRotor();
                Salida = Salida + " [";
                int NumNewChars = Porcent * (this.MaxChars - 9) / 100;
                for (i = 0; i < NumNewChars; ++i) {
                    Salida = Salida + this.BarChar;
                }
                if (NumNewChars < this.MaxChars - 9) {
                    Salida = Salida + ">";
                    for (i = ++NumNewChars; i < this.MaxChars - 9; ++i) {
                        Salida = Salida + " ";
                    }
                }
                Salida = Salida + "] ";
                this.Progress = Porcent;
                Salida = Salida + String.valueOf(this.Progress) + "%\r";
            } else {
                Salida = Salida + this.DrawRotor();
            }
        }
        return Salida;
    }

    public String PlotProgressBar(int Porcent) {
        double difference;
        String Salida = "";
        if (this.Plot_Start_Time == -1L) {
            difference = 1.0;
        } else {
            this.Plot_End_Time = System.nanoTime();
            difference = (double)(this.Plot_End_Time - this.Plot_Start_Time) / 1.0E9;
        }
        if (difference >= 0.03 || Porcent == 100) {
            Salida = this.DrawProgressBar(Porcent);
            this.Plot_Start_Time = System.nanoTime();
        }
        return Salida;
    }

    public void ResetTimerPlotProgressBar() {
        this.Plot_Start_Time = -1L;
    }

    public String PlotRotor() {
        double difference;
        String Salida = "";
        if (this.Plot_Start_Time == -1L) {
            difference = 1.0;
        } else {
            this.Plot_End_Time = System.nanoTime();
            difference = (double)(this.Plot_End_Time - this.Plot_Start_Time) / 1.0E9;
        }
        if (difference >= 0.03) {
            Salida = this.DrawRotor();
            this.Plot_Start_Time = System.nanoTime();
        }
        return Salida;
    }

    public void ResetTimerPlotRotor() {
        this.Plot_Start_Time = -1L;
    }
}

